# dataset used in "Parties influence during government policy negotiations: parliamentary dynamics and spatial advantages in the First Italian Republic" by Luigi Curini and Andrea Ceron (Journal of Legislative Studies)

use "C:\Users\curini\Desktop\cabinet policy bargaining.dta", clear

# list of variables included in the dataset
# DISTANCE: the Euclidean distance between each partys ideal point and the cabinets declared policy position
# - Cabinet-Level variables
# CABINET_PARTY: 1 if party i is a member of cabinet j. 0 otherwise
# CABINET_SHARE: Proportion of cabinet seats controlled by party i at time t
# FORMATEUR: 1 if party i is a formateur party during the vote of confidence of cabinet j. 0 otherwise
# SUPPORT_PARTY: 1 if party i supported cabinet j during the vote of confidence (without being a cabinet member). 0 otherwise
# MINORITY_CABINET: a dummy that identifies minority cabinets 
# FIRST_CABINET: a dummy that distinguishes governments formed immediately after elections from all the others 
# - Parliamentary-Level variables
# PARLIAMENTARY_SHARE: Proportion of parliamentary seats controlled by party i at time t
# ANTI_SYSTEM: 1 if party i is an anti-system party. 0 otherwise
# CORE_PARTY: 1 if party i is a core party during the cabinet policy-space j. 0 otherwise
# CYCLESET_PARTY: 1 if party i delimits the cycle-set during the cabinet policy-space j. 0 otherwise
# ECCENTRICITY: a variable that measures the relative distance in absolute terms between each non-cabinet party i 
# and the ideological barycentre of the Parliament at the time of each legislative speech, 
# estimated as the average position of all parties weighted by their respective seat share along the two dimensions

# other variables
# legislative_years: years of legislature (including the Constituent Assembly 1946-1948)
# cabinet_name: Prime Minister
# party: name of party (string)
# party_code: name of party (numerical value)

##########################################
##########################################
# Models 1-6 reported in Table 3
##########################################
##########################################

# Model 1
reg  DISTANCE CABINET_PARTY  CABINET_SHARE FORMATEUR SUPPORT_PARTY, cluster(party_code)

estat ic

# Model 2
reg  DISTANCE PARLIAMENTARY_SHARE  ANTI_SYSTEM CORE_PARTY CYCLESET_PARTY, cluster(party_code)

estat ic

# Model 3
reg  DISTANCE CABINET_PARTY  CABINET_SHARE FORMATEUR SUPPORT_PARTY ///
PARLIAMENTARY_SHARE  ANTI_SYSTEM CORE_PARTY CYCLESET_PARTY, cluster(party_code)

estat ic

# Model 4
reg  DISTANCE CABINET_PARTY  CABINET_SHARE FORMATEUR SUPPORT_PARTY ///
MINORITY_CABINET FIRST_CABINET ///
PARLIAMENTARY_SHARE  ANTI_SYSTEM CORE_PARTY CYCLESET_PARTY, cluster(party_code)

estat ic

# Model 5
reg DISTANCE SUPPORT_PARTY ///
MINORITY_CABINET FIRST_CABINET ///
PARLIAMENTARY_SHARE  ANTI_SYSTEM CYCLESET_PARTY if CABINET_PARTY==0, cluster(party_code)

estat ic

# Model 6
reg DISTANCE SUPPORT_PARTY ///
MINORITY_CABINET FIRST_CABINET ///
PARLIAMENTARY_SHARE  ANTI_SYSTEM CYCLESET_PARTY ECCENTRICITY if CABINET_PARTY==0, cluster(party_code)

estat ic










